
/*      get_double()
 *
 *      Subroutine to enable the demux routine to
 *      read double precision floating point numbers (8 bytes)
 *      in files transferred from an IBM machine.
 *      IBM will align on 16 bit fields, thus the structure
 *      in qmips.h will work properly on an IBM.
 *      The DEC will align on 32 bit fields in the most
 *      restrictive case, however, and a read into the structure
 *      in qmips.h causes problems.
 */

double    get_double(location)
unsigned char    *location;
{
    int    i;
    unsigned char    *ptr1, *ptr3;
    double *ptr2;
    double value;

    ptr1 = location;
    ptr3 = (unsigned char *) calloc (1, sizeof (double));

    if (INTEL) {
        
            for (i = 0; i < 8; i++)
            *ptr3++ = *ptr1++;
    }

    if (MOTOROLA) {
        ptr1 += 7;
        for (i = 0; i < 8; i++)
            *ptr3++ = *ptr1--;
    }

    ptr3 -= 8;

    ptr2 = (double *) ptr3;

    value = *ptr2;

    free (ptr3);

    return(value);

}


/*      get_float()
 *
 *      Subroutine to enable the demux routine to
 *      read IEEE floating point numbers (4 bytes)
 *      in files transferred from an IBM machine.
 *      IBM will align on 16 bit fields, thus the structure
 *      in qmips.h will work properly on an IBM.
 *      The DEC will align on 32 bit fields in the most
 *      restrictive case, however, and a read into the structure
 *      in qmips.h causes problems.
 */

float    get_float(location)
unsigned char    *location;
{
    int    i;
    unsigned char    *ptr1, *ptr3;
    float    *ptr2;

    ptr1 = location;
    ptr3 = location;
/*
    ptr3 = (unsigned char *) calloc (1, sizeof (float));
*/

    if (INTEL || VAX) {

        for (i = 0; i < 4; i++)
            *ptr3++ = *ptr1++;
    }

    if (MOTOROLA) {
        ptr1 += 3;

        for (i = 0; i < 4; i++)
            *ptr3++ = *ptr1--;
    }

    ptr3 -= 4;

    ptr2 = (float *) ptr3;
/*
    free (ptr3);
*/

    return(*ptr2);
}


/*      get_short()
 *
 *      Subroutine to enable the demux routine to
 *      read floating point numbers (4 bytes)
 *      in files transferred from an IBM machine.
 *      IBM will align on 16 bit fields, thus the structure
 *      in qmips.h will work properly on an IBM.
 *      The DEC will align on 32 bit fields in the most
 *      restrictive case, however, and a read into the structure
 *      in qmips.h causes problems.
 */

short    get_short(location)
unsigned char    *location;
{
    int    i;
    unsigned char    *ptr1, *ptr3;
    short    *ptr2;
    short value;

    ptr1 = location;
    ptr3 = (unsigned char *) calloc (1, sizeof (short));

    if (INTEL || VAX) {
        
            for (i = 0; i < 2; i++)
            *ptr3++ = *ptr1++;
    }

    if (MOTOROLA) {
        ptr1++;
        for (i = 0; i < 2; i++)
            *ptr3++ = *ptr1--;
    }

    ptr3 -= 2;

    ptr2 = (short *) ptr3;

    value = *ptr2;

    free (ptr3);

    return(value);
}


/*      get_int()
 *
 *      Subroutine to enable the demux routine to
 *      read integer numbers (4 bytes)
 *      in files transferred from an IBM machine.
 *      IBM will align on 16 bit fields, thus the structure
 *      in qmips.h will work properly on an IBM.
 *      The DEC will align on 32 bit fields in the most
 *      restrictive case, however, and a read into the structure
 *      in qmips.h causes problems.
 */

int   get_int(location)
unsigned char   *location;
{
        int     i;
        unsigned char   *ptr1, *ptr3;
        int   *ptr2;

        ptr1 = location;
        ptr3 = (unsigned char *) calloc (1, sizeof (int));
        if (INTEL || VAX) {

                for (i = 0; i < 4; i++)
                        *ptr3++ = *ptr1++;
        }

        if (MOTOROLA) {
                ptr1 += 3;

                for (i = 0; i < 4; i++)
                        *ptr3++ = *ptr1--;
        }

        ptr3 -= 4;

        ptr2 = (int *) ptr3;
        free (ptr3);


        return(*ptr2);
}


/*
void floatFlip(ptr1, ptr2)
unsigned char *ptr1;
unsigned char *ptr2;
{
    int i;

    ptr1 += 3;
    for(i = 0; i < 4; i++)
          *ptr2++ = *ptr1--;

    ptr2 -= 4;

}

*/

float floatFlip(value)
float *value;
{
    int i;
    unsigned char *ptr1, *ptr3;
    float *ptr2;
    float returnValue;

    ptr1 = (unsigned char *) value;
    ptr3 = (unsigned char *) calloc (1, sizeof (float));

    ptr1 += 3;
    for(i = 0; i < 4; i++)
          *ptr3++ = *ptr1--;

    ptr3 -= 4;

    ptr2 = (float *) ptr3;

    returnValue = *ptr2;

    free(ptr3);

    return(returnValue);
}

/*      getcentlon()
 *
 *      Returns the central longitude for the array lon in the UTM standard
 */

double getcentlon (lon)
double lon;
{
        int fuse;
        double c_lon;


        if (lon > 0.0)
                lon += 6.0;
        else
                lon -= 6.0;
        fuse = lon / 6;

        if (lon > 0.0)
                fuse -= 1;
        c_lon = 3.0 + fuse * 6.0;

        return(c_lon);
}


