/*		this routine compliments of
 *		mark weidersphan of university
 *		of texas at austin, institute
 *		for geophysics
 *
 * ieeibm is a routine to convert ieee standard floating
 * point numbers to short(32bit) ibm floating point numbers
 * arguments:
 *	1. ieee floating point number to convert(pointer-C)
 *	2. resulting ibm floating point number (pointer-C)
 *	3. number of elements to convert (pointer - C)
 *
*/
#define MSK_MANT_IEEE 0x7fffff
#define MSK_EXP_IEEE  0x7f800000
#define MSK_SIGN_IEEE 0x80000000
#define MSK_NORM      0x1000000

void ieeibm (ieee_fpn, ibm_fpn, nval)
register int   *ieee_fpn, *ibm_fpn, *nval;
{
    register int    exponent,
                    mantissa,
                    i;
    int     sign;

    for (i = 0; i < *nval; i++)
    {
	if (*ieee_fpn == 0)
	    *ibm_fpn = 0;
	else
	{
	    mantissa = (*ieee_fpn & MSK_MANT_IEEE) | 0x800000;
	    exponent = ((*ieee_fpn & MSK_EXP_IEEE) >> 23) - 126;
	    sign = (*ieee_fpn & MSK_SIGN_IEEE);
	    while ((exponent & 0x03) != 0)/* normalize */
	    {
		exponent++;
		mantissa >>= 1;
	    }
	    exponent = ((exponent >> 2) + 64) << 24;
	/* bit align exponent */
	    *ibm_fpn = sign | exponent | mantissa;
	}
	ieee_fpn++;
	ibm_fpn++;
    }

    return;
}
