/*
 *	sonar.h
 *
 *	Hi resolution side scan sonar include file for 
 *	QMIPS data.
 */

#include <math.h>

#if defined (vax)
#define VAX 1
#else
#define VAX 0
#endif

#if defined (mc68000) || defined (sony) || defined(sgi) || defined(sun)
#define MOTOROLAj 1
#else
#define MOTOROLA 0
#endif

#if defined  (ultrix) || defined (__alpha) || defined (INTEL)
#define INTEL 1
#else
#define INTEL 0
#endif


/* Symbolic constants for the "lseek" function: (if no <values.h>
	COMMENTED OUT ON DECSTATION -- THESE ARE IN stdio.h
#define SEEK_SET 0       Set file pointer to offset 
#define SEEK_CUR 1       Set file pointer to its current value plus offset 
#define SEEK_END 2       Set file pointer to the size of the file plus offset 
*/

unsigned int TRECSIZE; 		/* size of a QMIPS record on disk (bytes) */
unsigned int RAWDATASIZE; 	/* size of sonar +/- subbottom image data  */
unsigned int SUB_BOTTOM_OFFSET;		/* pointer to subbottom data */
unsigned int DATASIZE;	/* number of pixels to read/write */

unsigned int HEADERSIZE = 1024;

#define SDATASIZE 	2048	/* size of one record of port and starboard (bytes) */
#define HEADSIZE	1024	/* size of header data in QMIPS file */
#define ALONG_DEC 	3	/* along-track decimation */
#define ACROSS_DEC  2	/* across-track decimation */
#define PMODE 		0666	/* pmode of output files */

#define FILE_HEADER_SIZE	1024	/* demuxed file header size */ 

/*	sizes (bytes) of compacted records
 */
	/* window size of decimation kernel */
#define C_WINSIZE ((ALONG_DEC) * (ACROSS_DEC))

	/* sonar data size after decimation */
#define C_SDATASIZE ((SDATASIZE) / (ACROSS_DEC))

#define C_PDATASIZE 	24		/* position data size */
#define LONG_C_PDATASIZE  256		/* position data size for revision 1 */
#define LONG_POS_SIZE  256			/* size of position data */
#define C_TOTSIZE ((C_SDATASIZE) + (C_PDATASIZE))	/* total size of orginal short buffer */
#define LONG_C_TOTSIZE ((C_SDATASIZE) + (LONG_C_PDATASIZE))	/* size of long buffer */
#define IMAGE_HEADER_SIZE 50 
/*	sizes (elements) of spline arrays
 */
#define MAX_NNODES 	480	/* max. number of navigation nodes (120 hrs) */
#define MAX_NSPL 	20000	/* max. number of spline points */

/*	geometery of SeaMARC swath
 */
#define NEAR_DIST 0.02	/*  distance from nadir to first data as ratio of swath width */
#define SWATH 200.0  /*  Klein swath width at a 7.5 ping/second pulse rate */
#define PING_INT 0.25   /*  Klein ping interval @ 200 meter swath width */

/*	ranges of dn values being used
 */
#define MIN_DN 1 
#define MAX_DN 254

/*	dn values for screen background and grid line and shadows
 */
#define SCREENBACKGROUND 255
#define SCREENGRID 0
#define SHADOW 1

/*	radian to degree conversion -- to get from degrees to radians,
 *      divide the number of degrees by this number.  To get from radians
 *	to degrees, multiply the number of radians by this number.
 */
#define RAD_TO_DEG  57.295780

/*	used to increment the fake UTM coordinates if navigation
 *	is to be faked in the demux process.
 */
int INCREMENT_UTM = 5.0;

/*
 *
 */
#define SEC_NET 600	

/*	structure c_buf, in which the compacted data are stored
 */
struct c_buf {
	float djday;
	float utm_n;
	float utm_e;
	float utm_azi;
	float depth;
	float alt;
	unsigned char s_data[C_SDATASIZE];
};

/*	file header structure.  Added to system on 4/5/91 to accomodate
 *	new information for each file. --bwd
 */
struct file_header {
	unsigned char spare[1024];
};


/*	new structure for compacted data which has been expanded
 *	to hold more variables -- updated 6/11/90 -- bwd
 *	expanded this out to 256k -- 11/13/90 -- bwd
 */
struct long_c_buf {		/* total header size = 256 bytes */
	double djday;		/* decimal julian day for time  */
	double utm_n;		/* UTM northing for ping position */
	double utm_e;		/* UTM easting for ping position */
	double utm_azi;	/* towfish azimuth determined from spline */
	float fish_azi;	/* original azimuth readings from towfish */
	float latitude;	/* latitude from QMIPS data file */
	float longitude;	/* longitude from QMIPS data file */
	float course;		/* course from nav -- Ship Gyro */
	float pitch;		/* fish pitch from telemetry */
	float roll;		/* fish roll from telemetry */
	float depth;		/* pressure depth measurement */
	float alt;		/* altitude in meters of sonar vehicle */
	float total_depth;	/* depth of seafloor at vehicle position */
	float range;		/* slant range to fish from Sonotech system */
	float sec;		/* total seconds from 00:00 GMT  */
	int year;			/* from nav system, saved in data file  */
	int julian_day;	/* from nav system, saved in data file  */
	int sdatasize;		/* # of bytes in ping: header + data   */
	int swath_width;	/* swath width in meters */
	float pulse_width;
	long power;		/* transmit power */
	int spare[39];		/* spare bytes for future use */
	unsigned char s_data[C_SDATASIZE]; 	/* sonar data */
};


struct long_pos_buf {
	double djday;		/* decimal julian day for time  */
	double utm_n;		/* UTM northing for ping position */
	double utm_e;		/* UTM easting for ping position */
	double utm_azi;	/* towfish azimuth determined from spline */
	float fish_azi;	/* original azimuth readings from towfish */
	float latitude;	/* latitude from QMIPS data file */
	float longitude;	/* longitude from QMIPS data file */
	float course;		/* course from nav -- Ship Gyro */
	float pitch;		/* fish pitch from telemetry */
	float roll;		/* fish roll from telemetry */
	float depth;		/* pressure depth measurement */
	float alt;		/* altitude in meters of sonar vehicle */
	float total_depth;	/* depth of seafloor at vehicle position */
	float range;		/* slant range to fish from Sonotech system */
	float sec;		/* total seconds from 00:00 GMT  */
	int year;			/* from nav system, saved in data file  */
	int julian_day;	/* from nav system, saved in data file  */
	int sdatasize;		/* # of bytes in ping: header + data */
	int swath_width;	/* swath width in meters */
	float pulse_width;
	long power;		/* transmit power */
	int spare[39];		/* spare bytes for future use */
};

/*	structure for the header of screen image files put directly on disc
*/
struct image_header {
	int image_w;
	int image_h;
	int pix_size;
	int back_color;
	float west;
	float south;
	float c_long;
	char filename[30];
};
