/* azidis.c
   program to compute the azimuth of the line joining two points
   at phi1, lam1 (start point) and phi2, lam2 (end point).
   Angles are passed in decimal degrees. Assumes a spherical earth.
   A. Malinverno
   March 7, 1986.	*/

#include <math.h>

main ()
{
	/* Clarke 1866 ellipsoid */
/*	double e2 = 0.00676863;
	double e4 = e2 * e2;
	double e6 = e2 * e2 * e2;
	double e = sqrt (e2);
	double ehalf = e / 2.0;
	double a = 6378206.4;	*/
	double pi = 3.14159265358979323846;
	
	float fphi1, flam1, fphi2, flam2;
	double phi1, lam1, phi2, lam2;
	double geoazi(), azi;
	double geodis(), dis;

	printf ("Input phi1 and lam1 \n");
	scanf ("%f %f", &fphi1, &flam1);
	printf ("Input phi2 and lam2 \n");
	scanf ("%f %f", &fphi2, &flam2);

	phi1 = fphi1;
	lam1 = flam1;
	phi2 = fphi2;
	lam2 = flam2;
	dis = geodis (phi1, lam1, phi2, lam2);
	azi = geoazi (phi1, lam1, phi2, lam2);

	printf ("phi1 is %15.10f \n", phi1);
	printf ("lam1 is %15.10f \n", lam1);
	printf ("phi2 is %15.10f \n", phi2);
	printf ("lam2 is %15.10f \n", lam2);
	printf ("azimuth(degrees) is %f \n", azi);
	printf ("distance(meters) is %f \n", dis);
}

double geoazi (phi1, lam1, phi2, lam2)	/* computes azimuth between 1 and 2 */
double phi1, lam1, phi2, lam2;		/* angles are in decimal degrees */
{
	double pi = 3.14159265358979323846;
	double sinphi1, sinphi2, cosphi1, cosphi2, cosdlam;
	double cosdelta, sindelta, cosazi;
	double azi; 

	phi1 = phi1 * pi / 180.0;
	lam1 = lam1 * pi / 180.0;
	phi2 = phi2 * pi / 180.0;
	lam2 = lam2 * pi / 180.0;
	sinphi1 = sin (phi1);
	sinphi2 = sin (phi2);
	cosphi1 = cos (phi1);
	cosphi2 = cos (phi2);
	cosdlam = cos (lam2 - lam1);

	cosdelta = sinphi1 * sinphi2 + cosphi1 * cosphi2 * cosdlam;
	cosdelta = fabs (cosdelta);
	sindelta = sqrt (1.0 - cosdelta*cosdelta);
	cosazi = (sinphi2 - sinphi1*cosdelta) / (cosphi1 * sindelta);
	if (cosazi > 1.0) cosazi = 1.0;
	if (cosazi < -1.0) cosazi = -1.0;
	azi = acos (cosazi);
	if (lam2 < lam1) azi = -azi;
	if (azi < 0) azi = azi + 2*pi;
	printf ("azimuth(radians) is %f \n", azi);
	azi = azi * 180.0 / pi;
	return (azi);
}

double geodis (phi1, lam1, phi2, lam2)	/* computes distance between 1 and 2 */
double phi1, lam1, phi2, lam2;		/* angles are in decimal degrees */
{
	double e2 = 0.00676863;		/* Clarke 1866 */
	double f = 1.0 - sqrt (1.0 - e2);
	double a = 6378206.4;	
	double pi = 3.14159265358979323846;
	double sinphi1, sinphi2, cosphi1, cosphi2, cosdlam, sinmphi;
	double cosdelta, delta, radius;
	double dis; 

	phi1 = phi1 * pi / 180.0;
	lam1 = lam1 * pi / 180.0;
	phi2 = phi2 * pi / 180.0;
	lam2 = lam2 * pi / 180.0;
	sinmphi = sin ((phi1 + phi2) / 2.0);
	sinphi1 = sin (phi1);
	sinphi2 = sin (phi2);
	cosphi1 = cos (phi1);
	cosphi2 = cos (phi2);
	cosdlam = cos (lam2 - lam1);

	cosdelta = sinphi1 * sinphi2 + cosphi1 * cosphi2 * cosdlam;
	cosdelta = fabs (cosdelta);
	delta = acos (cosdelta);
	radius = a * (1.0 - f * sinmphi * sinmphi);	/* radius of ellipsoid at mean phi */
	dis = radius * delta;
	return (dis);

}
