/* spline.c
   subprogram that uses the spline algorithm in Cheney and Kincaid, 
   "Numerical Mathematics and Computing", Brooks/Cole, p. 258 ff., 1985.
   -	inputt is the input time or x coordinate;
   -	inputy is the input function to interpolate;
   -	inputn is the number of input points;
   -	outputn is the number of interpolations, and must be passed by the 
   	calling program. Note that this subroutine returns outputn + 1
	points, because of the endpoint.
   A. Malinverno
   Sep. 9 1986	*/

#include <stdio.h>


int beamSpline (inputt, inputy, inputn, outputt, outputy, outputn)
double *inputy, *outputy;
double *inputt, *outputt;
int inputn, outputn;
{
	int i;
	double t0, tmax, deltat, t;
	double z[500];
	double spl3();
	void zspl3();

	t0 = inputt[0];
	tmax = inputt[inputn - 1];
	deltat = (tmax - t0) / outputn;
	zspl3 (inputt, inputy, z, inputn);
	for (i = 0; i < outputn + 1; i++)
	{
		t = t0 + i * deltat;
		outputt[i] = t;
		outputy[i] = spl3 (t, inputt, inputy, z, inputn);
	}
	return (i);
}
	
void beamZspl3(t, y, z, n, max)
double y[90][100];
double t[90][100], z[90][100];
int n, max;
/* subroutine to compute the z's and return them in the z array */
{
	double h[10000], b[10000], u[10000], v[10000];
	int i, j;

	for (i = 0; i < (n - 1); i++)
		{
		for (j = 0; j < max - 1; j++)
			{
			h[i + j] = *(*(t+i+1)+j) - *(*(t+i)+j);
			b[i + j] = (*(*(y+i+1)+j) - *(*(y+i)+j) ) / h[i];
			}
		}
	u[1] = 2.0 * (h[0] + h[1]);
	v[1] = 6.0 * (b[1] - b[0]);
	for (i = 2; i < ((n * max) - 1); i++)
		{
		u[i] = 2.0 * (h[i] + h[i-1]) - h[i-1] * h[i-1] / u[i-1];
		v[i] = 6.0 * (b[i] - b[i-1]) - h[i-1] * v[i-1] / u[i-1];
		}
	*(*(z+(n-1))+max) = 0.0;

	for (i = (n - 2); i > 0; i--)
		for (j = (max - 2); j > 0; j--)
			{
			*(*(z+i)+j) = (v[i+j] - h[i+j] * *(*(z+i+1)+j)) / u[i+j];
/*
fprintf(stdout, "z[%d][%d] = %lf\n", i, j, *(*(z+i)+j) );
*/
			}

	*(*(z+0)+0) = 0.0;
}

double beamSpl3 (angle, x, t, y, z, n)
int angle;
double y[90][100];
double x, z[90][100], t[90][100];
int n;
/* returns the value of the spline at x */
{
	double sply, diff, h, b, p;
	int i;

	for (i = (n - 2); i > 0; i--)
	{
		diff = x - *(*(t+angle)+i);
		if (diff >= 0.0) break;
	}
	if (diff < 0.0)
	{
		i = 0;
		diff = x - *(*(t+0)+0);
	}
	h = *(*(t+angle+1)+i) - *(*(t+angle)+i);
	b = (*(*(y+angle+1)+i) - *(*(y+angle)+i)) /
				h - h * (*(*(z+angle+1)+i) + 2.0 * *(*(z+angle)+i)) / 6.0;
	p = 0.5 * *(*(z+angle)+i) + diff * (*(*(z+angle+1)+i)
									- *(*(z+angle)+i)) / (6.0 * h);
	p = b + diff * p;
	sply = *(*(y+angle)+i) + diff * p;
	return (sply);
}

