/* spline.c
   subprogram that uses the spline algorithm in Cheney and Kincaid, 
   "Numerical Mathematics and Computing", Brooks/Cole, p. 258 ff., 1985.
   -	inputt is the input time or x coordinate;
   -	inputy is the input function to interpolate;
   -	inputn is the number of input points;
   -	outputn is the number of interpolations, and must be passed by the 
   	calling program. Note that this subroutine returns outputn + 1
	points, because of the endpoint.
   A. Malinverno
   Sep. 9 1986	*/


double spl3 (x, t, y, z, n)
double x, *t, *y, *z;
int n;
/* returns the value of the spline at x */
{

	double sply, diff, h, b, p;
	int i;

	for (i = (n - 2); i > 0; i--)
	{
		diff = x - t[i];
		if (diff >= 0.0) break;
	}
	if (diff < 0.0)
	{
		i = 0;
		diff = x - t[0];
	}
	h = t[i+1] - t[i];
	b = (y[i+1] - y[i]) / h - h * (z[i+1] + 2.0 * z[i]) / 6.0;
	p = 0.5 * z[i] + diff * (z[i+1] - z[i]) / (6.0 * h);
	p = b + diff * p;
	sply = y[i] + diff * p;
	return (sply);
}

