/* spline.c
   subprogram that uses the spline algorithm in Cheney and Kincaid, 
   "Numerical Mathematics and Computing", Brooks/Cole, p. 258 ff., 1985.
   -	inputt is the input time or x coordinate;
   -	inputy is the input function to interpolate;
   -	inputn is the number of input points;
   -	outputn is the number of interpolations, and must be passed by the 
   	calling program. Note that this subroutine returns outputn + 1
	points, because of the endpoint.
   A. Malinverno
   Sep. 9 1986	*/

int spline (inputt, inputy, inputn, outputt, outputy, outputn)
double *inputt, *inputy, *outputt, *outputy;
int inputn, outputn;
{
	int i;
	double t0, tmax, deltat, t;
	double z[1000];
	double spl3();
	void zspl3();

	t0 = inputt[0];
	tmax = inputt[inputn - 1];
	deltat = (tmax - t0) / outputn;
	zspl3 (inputt, inputy, z, inputn);
	for (i = 0; i < outputn + 1; i++)
	{
		t = t0 + i * deltat;
		outputt[i] = t;
		outputy[i] = spl3 (t, inputt, inputy, z, inputn);
	}
	return (i);
}
	
void zspl3 (t, y, z, n)
double *t, *y, *z;
int n;
/* subroutine to compute the z's and return them in the z array */
{
	double h[1000], b[1000], u[1000], v[1000];
	int i;

	for (i = 0; i < (n - 1); i++)
	{
		h[i] = t[i+1] - t[i];  /* diff of next time and current time */
		b[i] = (y[i+1] - y[i]) / h[i];
	}
	u[1] = 2.0 * (h[0] + h[1]);
	v[1] = 6.0 * (b[1] - b[0]);
	for (i = 2; i < (n - 1); i++)
	{
		u[i] = 2.0 * (h[i] + h[i-1]) - h[i-1] * h[i-1] / u[i-1];
		v[i] = 6.0 * (b[i] - b[i-1]) - h[i-1] * v[i-1] / u[i-1];
	}
	z[n-1] = 0.0;
	for (i = (n - 2); i > 0; i--)
		z[i] = (v[i] - h[i] * z[i+1]) / u[i];
	z[0] = 0.0;
}
